<?php
/**********************************************************
	Phoenix Labs/iBot Core Development Class
	includes all MySQL/database functions

	version: 1.0.0

	last modified: January 11, 2011
	
	methods: 
	======================================================	
	get_var(SQL)			replace default ezSQL $wpdb function
	get_row(SQL)			replace default ezSQL $wpdb function
	get_results(SQL)		replace default ezSQL $wpdb function
	query(SQL)				replace default ezSQL $wpdb function	
	set_prefix(SQL)			replace {prefix} with $wpdb->prefix
	dbsafe(DATA)			make DATA safe for MySQL
	num_rows()				get num_rows of last query
	insert(table, array)			insert array into table
	update(table, array, where)		update table with array
	
**********************************************************/
class plb2_wpdb {

	//****************************************************
	// get_var from MySQL
	public function get_var($sql, $debug=FALSE) {
		global $plb2, $wpdb;
		$sql = $plb2->db->set_prefix($sql); 		
		If($debug){print $sql;}
		return $wpdb->get_var($sql);
	}

	//****************************************************
	// get_row from MySQL
	public function get_row($sql, $debug=FALSE) {
		global $plb2, $wpdb;
		$sql = $plb2->db->set_prefix($sql); 
		If($debug){print $sql;}
		return $wpdb->get_row($sql);
	}

	//****************************************************
	// get_results from MySQL
	public function get_results($sql, $debug=FALSE) {
		global $plb2, $wpdb;
		$sql = $plb2->db->set_prefix($sql); 
		If($debug){print $sql;}
		return $wpdb->get_results($sql);
	}

	//****************************************************
	// query from MySQL
	public function query($sql, $debug=FALSE) {
		global $plb2, $wpdb;
		$sql = $plb2->db->set_prefix($sql); 
		$sql = $wpdb->prepare($sql); 
		If($debug){print $sql;}
		return $wpdb->get_results($sql);
	}

	//****************************************************
	// set_prefix for MySQL table
	public function set_prefix($sql) {
		global $wpdb;
		$sql = str_replace('{prefix}', $wpdb->prefix, $sql); 
		return $sql; 
	}
	
	// ********************************************************************
	// make data safe for MySQL
	public function dbsafe($data) {

		// special characters
		//http://www.ascii.cl/htmlcodes.htm
		$clean = array(	'$'=>'&#36;',		
						'%'=>'&#37;',
						'*'=>'&#42;',
						'+'=>'&#43;');
		foreach($clean as $needle=>$replace) {$data = str_replace($needle, $replace, $data);}  

		// generic clean-up
		// $data = strip_tags($data); allow HTML
		$data = stripslashes($data); 
		$data = mysql_real_escape_string($data); 
		return $data;
	}	
	
	
	// ********************************************************************
	// return num rows of last query
	public function num_rows() {
		global $wpdb;
		return $wpdb->num_rows; 
	}	
	
	//****************************************************
	// insert array into MySQL
	public function insert($table, $array, $debug=FALSE) {		
		global $wpdb, $plb2; 
		$sql = "INSERT INTO `".$table."` SET ";
		foreach($array as $col=>$var) {$sql .= "`".$plb2->db->dbsafe($col)."`='".$plb2->db->dbsafe($var)."',";}
		$sql = substr($sql, 0, -1);
		$sql = $plb2->db->set_prefix($sql); 
		$sql = $wpdb->prepare($sql); 
		If($debug){print $sql;}
		$wpdb->query($sql);
		return $wpdb->insert_id;
	}		
	
	//****************************************************
	// update array into MySQL
	public function update($table, $array, $where, $debug=FALSE) {		
		global $wpdb, $plb2; 
		$sql = "UPDATE `".$table."` SET ";
		foreach($array as $col=>$var) {$sql .= "`".$plb2->db->dbsafe($col)."`='".$plb2->db->dbsafe($var)."',";}
		$sql = substr($sql, 0, -1);
		$sql.= " ".$where;
		$sql = $plb2->db->set_prefix($sql); 
		$sql = $wpdb->prepare($sql); 
		If($debug){print $sql;}	
		$wpdb->query($sql);
		return;
	}	
}
?>