<?php
/****************************************************************************
	Phoenix Labs/iBot Core Development Class
	
	includes main framework for plbot plugins

	version: 1.0.0

	last modified: January 11, 2011
	
	Notes: 
	
	The meat and potatoes of the plugin is right here - we create 
	our master class, load all needed modules, set our admin menu,
	edit our headers, and handle all WordPress hooks in here. 
	
	
/****************************************************************************/
class plb2_core {

	// ***************************************************************************
	// class variables
	var $path='';			// path to this plugin
	var $url='';			// url to this plugin	
	protected $data=array();	// array for passing data back and forth	
	protected $msg=array();		// array of messages
	protected $error=array();	// array of errors

	// *******************************************************************
	// initialize plugin class and load all needed modules
	public function __construct() {
	
		// set path and url to current plugin
		$this->path=dirname(dirname(__FILE__));
		$this->url=get_bloginfo('url').'/wp-content/plugins/'.basename(dirname(dirname(__FILE__))).'/';

		// load custom module- all plugin-specific functions go here
		require_once 'custom.002.php';
		$this->custom = new plb2_custom(); 			

		// load form module- all functions that deal with forms
		require_once 'plb.form.php';
		$this->form = new plb2_form();	

		// load db module- all functions that interact with MySQL
		require_once 'plb.wpdb.php';
		$this->db = new plb2_wpdb();		
  	}
  	
  	
	// *******************************************************************
	// all of our WordPress hooks go here
	public function init() {
		global $wpdb;
		
		// wordpress hooks
		add_action('init', array(&$this, 'wpinit'));
		add_action('admin_menu', array(&$this, 'admin_menu'));
		add_action('admin_head', array(&$this, 'header_admin')); 
		add_action('wp_head', array(&$this, 'header_theme')); 
		add_filter('the_content', array(&$this, 'custom1'));
		
		// create MySQL table
		$table_name = $wpdb->prefix.'plb2_data';
		if($wpdb->get_var("show tables like '$table_name'") != $table_name):
			$sql = "CREATE TABLE `$table_name` (
				`ID` bigint(16) NOT NULL AUTO_INCREMENT,
				`keyword` varchar(255) NOT NULL,
				`key_size` bigint(9) NOT NULL,				
				`url` text NOT NULL,
				 PRIMARY KEY (`ID`));";
			require_once( ABSPATH . 'wp-admin/upgrade-functions.php' );
			dbDelta($sql);
		endif;
	}  

	// ***********************************************************
	// I like keeping all custom functions in their own file
	public function custom1($content) {global $plb2; return $plb2->custom->add_seo_links($content);}
	
	// ***********************************************************
	// run when WordPress initializes
	public function wpinit() {

		// load AJAX classes
		//wp_enqueue_script('jquery');		
		//wp_enqueue_script('scriptaculous');
	}
	
	// ***********************************************************
	// generate admin menu
	public function admin_menu() {
		global $plb2;
		add_menu_page(PLB2_NAME,PLB2_NAME,'administrator','plb2_admin',array(&$this, 'load_page'),$plb2->url.'branding/menu.png');				
		//add_submenu_page('ibot_parents','New Registrations','New Registrations','administrator','ibot_parents',array(&$this, 'load_page'));		
	}	


	// *******************************************************************	
	// header for admin section (wp-admin)
	public function header_admin() { ?>		
		<style type="text/css">
			@import url("<?=$this->url?>branding/custom.css");
		</style>	
	<? }		
	
	// *******************************************************************	
	// header for public theme
	public function header_theme() { ?>
	<? }	


	// ***************************************************************************
	// DO NOT EDIT BELOW THIS LINE UNLESS YOU MUST
	// *******************************************************************
	// load a page from /pages
	public function load_page($file, $folder='admin') {
		global $plb2;
		If(empty($file)) {$file=$_GET["page"];}
		If(!empty($_GET["view"])) {$file = $file.'_view';}		
		$path = $plb2->path.'/pages/';
		If(!empty($folder)) {$path.=$folder.'/';}
		$path .= $file.'.php';  
		require_once $path;
	}  

	// *******************************************************************
	// set a message for user
	public function set_msg($msg,$mode='ALERT',$field='FORM') {
		global $plb2;

		// set CSS based on mode
		switch($mode):

			case 'SUCCESS': 
				$css='color:#267c2c;background:#ccf1cf;border:2px solid #267c2c;margin:10px 0px 10px 0px;padding:5px;border-radius:5px;-moz-border-radius:5px;-webkit-border-radius:5px;';
				break;
				
			case 'ALERT': 
				$css='color:#c37725;background:#fffed0;border:2px solid #c37725;margin:10px 0px 10px 0px;padding:5px;border-radius:5px;-moz-border-radius:5px;-webkit-border-radius:5px;';
				break;

		endswitch;

		// set message and send to array		
		$msg = '<div style="'.$css.'">'.$msg.'</div>';
		$array = array($field=>$msg); 
		array_push($this->msg, $array);		
	}  
	
	// *******************************************************************	
	// show message to user
	public function msg($show_field='FORM') {
		foreach($this->msg as $array) {foreach($array as $key=>$val) {If(($key==$show_field) || ($show_field=='ALL')) {print $val;}}}
	}	
}
?>